/*---------------------------------------------------------------------------*\

    FILE....: TPLAYREC.CPP
    TYPE....: C++ Console program
    AUTHOR..: David Rowe
    DATE....: 10/3/02

    Thest program for playrec routines.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2002 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "threads.h"

#include "../src/vpbapi.h"
#include "../src/verbose.h"

void *event_thread(void *pv);
int arg_exists(int argc, char *argv[], char *arg);
int ctwaitforevent(int h, void *timer,int event_type,int data,int timeout_ms);
int finish;

int main(int argc, char * argv[])
{
	int	        h;
	pthread_t       ev_thread;
	VPB_RECORD	record;
	VPB_PLAY	play;
	void            *timer;

	vpb_seterrormode(VPB_DEVELOPMENT);
	h = vpb_open(1,1);
	pthread_create(&ev_thread, NULL, event_thread, NULL);
	record.term_digits = "";
	record.time_out = 2000;
	vpb_record_set(h, &record);
        vpb_timer_open(&timer, h, 0, 1000);

	vpb_sethook_sync(h, VPB_OFFHOOK);
	
	#define WAV
	#ifdef WAV
	printf("sync wav....\n");
	vpb_record_file_sync(h, "test.wav", VPB_LINEAR);
	vpb_play_file_sync(h, "test.wav");
	
	printf("async wav....\n");
	vpb_record_file_async(h, "test.wav", VPB_LINEAR);
        ctwaitforevent(h, timer, VPB_RECORDEND, VPB_RECORD_TIMEOUT, 4000);
	vpb_play_file_async(h, "test.wav", 0);
        ctwaitforevent(h, timer, VPB_PLAYEND, 0, 4000);
	#endif

	#define VOX
	#ifdef VOX
	printf("sync vox....\n");
	vpb_record_voxfile_sync(h, "test.vox", VPB_LINEAR);
	vpb_play_voxfile_sync(h, "test.vox", VPB_LINEAR);
	
	printf("async vox....\n");
	vpb_record_voxfile_async(h, "test.vox", VPB_LINEAR);
        ctwaitforevent(h, timer, VPB_RECORDEND, VPB_RECORD_TIMEOUT, 4000);
	vpb_play_voxfile_async(h, "test.vox", VPB_LINEAR, 0);
        ctwaitforevent(h, timer, VPB_PLAYEND, 0, 4000);
	#endif

	//#define DIGTERM
	#ifdef DIGTERM
	record.term_digits = "1";
	record.time_out = 10000;
	vpb_record_set(h, &record);
	printf("digit termination on record async wav - press a 1....\n");
	vpb_record_file_async(h, "test.wav", VPB_LINEAR);
        ctwaitforevent(h, timer, VPB_RECORDEND, 0, 10000);

	play.term_digits = "2";
	vpb_play_set(h, &play);
	printf("digit termination on play async wav - press a 2....\n");
	vpb_play_file_async(h, "test.wav", 0);
        ctwaitforevent(h, timer, VPB_PLAYEND, 0, 10000);
	#endif

	vpb_sethook_sync(h, VPB_ONHOOK);

	finish = 1;
	while(finish)
	  vpb_sleep(20);

	vpb_close(h);

	return 0;
}

void *event_thread(void *pv) {
	char	  s[VPB_MAX_STR];
        VPB_EVENT e;

	do {
		// check for events from VPB

		while(vpb_get_event_async(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf(s);
		}

	} while(!finish);

	finish = 0;

	return NULL;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}

int ctwaitforevent(int h,void *timer,int event_type,int data,int timeout_ms) {
  char      s[VPB_MAX_STR];
  int       ret, state;
  VPB_EVENT e;   

  vpb_timer_change_period(timer, timeout_ms);
  if (timeout_ms != 0)
    vpb_timer_start(timer);

  state = 1;
  while(state && !finish) {
    ret = vpb_get_event_ch_async(h, &e);

    if (ret == VPB_OK) {
      vpb_translate_event(&e, s); s[strlen(s)-1]=0;

      if ((e.type == event_type) && (e.data == data)) {
	state = 0;
      }
      if (e.type == VPB_TIMEREXP) {
	state = 0;
      }
    }
    else
      vpb_sleep(100);
  }
	  
  vpb_timer_stop(timer);	
  if (state == 0)
    return e.type;
  else
    return -1;
}


